#pragma once

class CRejestr
{
private:
   HKEY uchwytKlucza;
   HKEY kluczGlowny; 
   REGSAM trybDostepu;
public:
   bool wyswietlajKomunikatyOBledach;

public:
	CRejestr(HKEY kluczGlowny,REGSAM trybDostepu,bool wyswietlajKomunikatyOBledach=true);
	~CRejestr(void);

	void WyswietlKomunikatBledu(LONG numerBledu) const;

	bool UtworzKlucz(const wchar_t* klucz);
	bool OtworzKlucz(const wchar_t* klucz);
	bool ZamknijKlucz();
	bool UsunKlucz(const wchar_t* klucz);
	bool CzyKluczIstnieje(const wchar_t* klucz) const;
	bool OtworzKlucz(const wchar_t* klucz,bool utworzJezeliNieIstnieje);

	bool CzyWartoscIstnieje(const wchar_t* nazwa) const;
	bool UsunWartosc(const wchar_t* nazwa) const;
	int CzytajInt(const wchar_t* nazwa) const;
	bool ZapiszInt(const wchar_t* nazwa,int wartosc) const;
	wchar_t* CzytajString(const wchar_t* nazwa,wchar_t* wartosc) const;
	bool ZapiszString(const wchar_t* nazwa,const wchar_t* zawartosc) const;
};

//przechowywanie polozenia i rozmiaru okna
bool CzytajPolozenieIWielkoscOknaZRejestru(HWND okno,const wchar_t* klucz);
void ZapiszPolozenieIWielkoscOknaWRejestrze(HWND okno,const wchar_t* klucz);

//autostart
bool CzyIstniejeZapisAutostart(HKEY kluczGlowny,const wchar_t* nazwa);
bool ZapiszAutostart(HKEY kluczGlowny,const wchar_t* nazwa,const wchar_t* sciezkaPliku);
bool UsunAutostart(HKEY kluczGlowny,const wchar_t* nazwa);

//dodaj/usun programy
struct CDodajUsunInfo 
{
	CString //dla wygody korzystam z CString zamiast wchar_t[]
		DisplayName, DisplayIcon, DisplayVersion,
		Contact, Publisher, Comments, URLUpdateInfo,
		URLInfoAbout, InstallLocation, InstallSource,
		ProductID, UninstallString, UninstallPath,
		ModifyPath, Readme, HelpLink, HelpTelephone,
		RegCompany, RegOwner, LogFile;
	int	VersionMajor, VersionMinor, NoRemove, NoRepair, Language;
};

bool CzyIstniejeZapisDodajUsun(const wchar_t* nazwaKlucza);
bool ZapiszDodajUsun(const wchar_t* nazwaKlucza,CDodajUsunInfo rekord);
bool UsunDodajUsun(const wchar_t* nazwaKlucza);

//katalogi specjalne uzytkownika
wchar_t* PobierzSciezkeDoKataloguSpecjalnego(const wchar_t* nazwa,wchar_t* katalog);
wchar_t* PobierzSciezkeDoKataloguMojeDokumenty(wchar_t* katalog);

//nowa komenda dla zarejestrowanego pliku
void RozszerzMenuKontekstoweIstniejacegoTypuPliku(const wchar_t* rozszerzenie,const wchar_t* polecenie,const wchar_t* opis);